/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.hook;

import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.entity.attribute.ExtendedRangedAttribute;
import com.charles445.rltweaker.entity.attribute.InversedAttributeInstance;
import java.util.List;
import meldexun.reflectionutil.ReflectionField;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class HookPotionCore {
    private static final ResourceLocation POTION_SICKNESS = new ResourceLocation("potioncore", "potion_sickness");
    private static final ResourceLocation TIPSY = new ResourceLocation("rustic", "tipsy");
    public static final ReflectionField<IAttribute> DAMAGE_RESISTANCE = new ReflectionField("com.tmtravlr.potioncore.PotionCoreAttributes", "DAMAGE_RESISTANCE", "DAMAGE_RESISTANCE");
    private static float originalDamage;

    public static void addPotionSicknessEffect(EntityLivingBase entity, List<Potion> possibleEffects) {
        PotionEffect potionEffect;
        Potion potion = possibleEffects.get(entity.func_70681_au().nextInt(possibleEffects.size()));
        PotionEffect potionEffect2 = potionEffect = potion.func_76403_b() ? new PotionEffect(potion, 1) : new PotionEffect(potion, 1200);
        if (ModConfig.server.potioncore.incurablePotionSickness) {
            ((Incurable)potionEffect).setIncurable(true);
        }
        entity.func_70690_d(potionEffect);
    }

    public static boolean isCurable(PotionEffect potionEffect) {
        ResourceLocation registryName = potionEffect.func_188419_a().getRegistryName();
        if (ModConfig.server.potioncore.incurablePotionSickness && registryName.equals((Object)POTION_SICKNESS)) {
            return false;
        }
        if (ModConfig.server.potioncore.incurableTipsy && registryName.equals((Object)TIPSY)) {
            return false;
        }
        if (((Incurable)potionEffect).isIncurable()) {
            return false;
        }
        return !ModConfig.server.potioncore.incurablePotionEffectsImpl.contains(registryName);
    }

    public static boolean isCureDisabled(EntityLivingBase entity) {
        return entity.func_70651_bq().stream().map(PotionEffect::func_188419_a).map(IForgeRegistryEntry.Impl::getRegistryName).anyMatch(ModConfig.server.potioncore.cureDisablingPotionEffectsImpl::contains);
    }

    public static PotionEffect onAddTipsyEffect(PotionEffect potionEffect) {
        if (ModConfig.server.potioncore.incurableTipsy) {
            ((Incurable)potionEffect).setIncurable(true);
        }
        return potionEffect;
    }

    public static RangedAttribute resistance_createAttribute(RangedAttribute originalAttribute) {
        if (!ModConfig.server.potioncore.alternativeResistanceMode) {
            return originalAttribute;
        }
        return new ExtendedRangedAttribute(null, originalAttribute.func_111108_a(), originalAttribute.func_111110_b(), 0.0, Double.MAX_VALUE){

            @Override
            public IAttributeInstance createInstance(AbstractAttributeMap attributeMap, IAttribute attribute) {
                return new InversedAttributeInstance(attributeMap, attribute);
            }
        };
    }

    public static Potion resistance_registerPotionAttributeModifier(Potion potion, IAttribute attribute, String uniqueId, double ammount, int operation) {
        return potion.func_111184_a(attribute, uniqueId, ModConfig.server.potioncore.resistanceAmount, ModConfig.server.potioncore.resistanceOperation);
    }

    public static Potion vulnerable_registerPotionAttributeModifier(Potion potion, IAttribute attribute, String uniqueId, double ammount, int operation) {
        return potion.func_111184_a(attribute, uniqueId, ModConfig.server.potioncore.vulnerableAmount, ModConfig.server.potioncore.vulnerableOperation);
    }

    public static double getAdjustedDamageResistanceAttribute(EntityLivingBase entity) {
        return 0.0;
    }

    public static void preResistancePotionCalculation(float damage) {
        originalDamage = damage;
    }

    public static float postResistancePotionCalculation(EntityLivingBase entity, float damage) {
        if (!DAMAGE_RESISTANCE.isPresent()) {
            return damage;
        }
        IAttributeInstance attribute = entity.func_110148_a(DAMAGE_RESISTANCE.get(null));
        if (ModConfig.server.potioncore.alternativeResistanceMode) {
            return (float)((double)originalDamage * attribute.func_111126_e());
        }
        return (float)((double)originalDamage * (1.0 - (attribute.func_111126_e() - 1.0)));
    }

    public static double getActualResistance(double resistance) {
        return ModConfig.server.potioncore.alternativeResistanceMode ? -resistance : resistance;
    }

    public static interface Incurable {
        public boolean isIncurable();

        public void setIncurable(boolean var1);
    }
}

